<!DOCTYPE html>
<html>
<head>
<title>Retrieving Autocomplete Predictions</title>
<style>
/* Always set the map height explicitly to define the size of the div
* element that contains the map. */
#map {
height: 100%;
}
/* Optional: Makes the sample page fill the window. */
html, body {
height: 100%;
margin: 0;
padding: 0;
}
#right-panel {
font-family: 'Roboto','sans-serif';
line-height: 30px;
padding-left: 10px;
}

#right-panel select, #right-panel input {
font-size: 15px;
}

#right-panel select {
width: 100%;
}

#right-panel i {
font-size: 12px;
}
</style>
</head>
<body>
<div id="right-panel">
<p>Query suggestions for 'pizza near kolkata':</p>
<ul id="results"></ul>
</div>
<script>
// This example retrieves autocomplete predictions programmatically from the
// autocomplete service, and displays them as an HTML list.

// This example requires the Places library. Include the libraries=places
// parameter when you first load the API. For example:
// <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">

function initService() {
var displaySuggestions = function(predictions, status) {
  if (status != google.maps.places.PlacesServiceStatus.OK) {
	alert(status);
	return;
  }

  predictions.forEach(function(prediction) {
	var li = document.createElement('li');
	li.appendChild(document.createTextNode(prediction.description));
	document.getElementById('results').appendChild(li);
  });
};

var service = new google.maps.places.AutocompleteService();
service.getQueryPredictions({ input: 'pizza near kolkata' }, displaySuggestions);
}
</script>
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDTwbEnr61ZMGwD5kC89JULP2gCJpqhYow&libraries=places&callback=initService"
async defer></script>
</body>
</html>