<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
<meta charset="utf-8">
<title>Polygon Auto-Completion</title>
<style>
/* Always set the map height explicitly to define the size of the div
* element that contains the map. */
#map {
height: 100%;
}
/* Optional: Makes the sample page fill the window. */
html, body {
height: 100%;
margin: 0;
padding: 0;
}
</style>
</head>
<body>
<div id="map"></div>
<script>

// This example creates a simple polygon representing the Bermuda Triangle. Note
// that the code specifies only three LatLng coordinates for the polygon. The
// API automatically draws a stroke connecting the last LatLng back to the first
// LatLng.

//init map-------------------------------------------------------------------------------------------------
function initMap() 
{

//
var map = new google.maps.Map(document.getElementById('map'), {
  zoom: 5,
  center: {lat: 24.886, lng: -70.268},
  mapTypeId: 'terrain'
});

// Define the LatLng coordinates for the polygon's path. Note that there's
// no need to specify the final coordinates to complete the polygon, because
// The Google Maps JavaScript API will automatically draw the closing side.
var triangleCoords = [
  {lat: 25.774, lng: -80.190},
  {lat: 18.466, lng: -66.118},
  {lat: 32.321, lng: -64.757}
];

var bermudaTriangle = new google.maps.Polygon({
  paths: triangleCoords,
  strokeColor: '#FF0000',
  strokeOpacity: 0.8,
  strokeWeight: 3,
  fillColor: '#FF0000',
  fillOpacity: 0.35,
  editable:true
});

bermudaTriangle.setMap(map);

}
//end init map-------------------------------------------------------------------------------------------------
</script>


<script 
src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDTwbEnr61ZMGwD5kC89JULP2gCJpqhYow&callback=initMap" 
async defer></script>
</script>


</body>
</html>