<?php

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Invoices_model extends CI_Model
{


//------------------------------------------------------------------------------------------------------------
function __construct() 
{
	parent::__construct();
}
//------------------------------------------------------------------------------------------------------------           




//------------------------------------------------------------------------------------------------------------
function get_user_payments_for_year_month($year,$month)
{

//
$companies_id=$this->companies_id ? $this->companies_id : '';
	
$sql="select 

SUM(dt_invoices.paid) AS paid 

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

left join dt_companies on
dt_invoices.company_id=dt_companies.id

left join dt_currency on
dt_invoices.currency_id=dt_currency.id

where

dt_invoices.id!=''

";

//..........................................................
if($year)
{
	$sql.="and year(dt_invoices.paid_date)='$year' ";
}
//..........................................................

//..........................................................
if($month)
{
	$sql.="and month(dt_invoices.paid_date)='$month' ";
}
//..........................................................


//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_invoices.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........

$sql.="\n GROUP BY dt_invoices.id ";

//echo nl2br($sql); exit;

$record=$this->common->get_query($sql);

return $record["paid"];

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------           
function get_user_sum_paid_outstanding()
{

//get list of user invoices
$record_invoice_list=$this->get_user_invoice_list();

//convert stdclass to array
$record_invoice_list = json_decode(json_encode($record_invoice_list), true);
//echo "<pre/>"; var_export($record_invoice_list);

//sum up only sum column
$arr_sum=array_column($record_invoice_list,'sum');
//var_export($arr_sum);
$sum=array_sum($arr_sum);

//sum up only paid column
$arr_paid=array_column($record_invoice_list,'paid');
//var_export($arr_paid);
$paid=array_sum($arr_paid);

//sum up only outstanding column
$arr_outstanding=array_column($record_invoice_list,'outstanding');
//var_export($arr_outstanding);
$outstanding=array_sum($arr_outstanding);


return array($sum,$paid,$outstanding);

}
//------------------------------------------------------------------------------------------------------------           




//------------------------------------------------------------------------------------------------------------
function get_user_invoice_list($status_id)
{

//
$companies_id=$this->companies_id ? $this->companies_id : '';
	
$sql="select 

dt_invoices.* 
, dt_invoice_status.name as invoice_status_name
, dt_companies.name as company_name
, dt_currency.name as currency_name

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

left join dt_companies on
dt_invoices.company_id=dt_companies.id

left join dt_currency on
dt_invoices.currency_id=dt_currency.id

where

dt_invoices.id!=''

";


//...............................................................
if(isset($status_id))
{
	$sql.="and dt_invoices.invoice_status_id='$status_id' ";
}
//...............................................................


//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_invoices.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........


//echo nl2br($sql); exit;

return $this->common->get_query_all($sql);

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function get_reports_invoices_by_clients()
{

//
$start_date=$_POST["start_date"] ? $_POST["start_date"] : date("Y-01-01");
$end_date=$_POST["end_date"];
$companies_id=$this->companies_id ? $this->companies_id : '';
//

$sql="select 

dt_companies.name as company_name
, sum(dt_invoices.paid) as total_paid

from 

dt_invoices 

left join dt_companies on
dt_invoices.company_id=dt_companies.id

where

dt_invoices.id!=''

";


$sql.="\n and dt_invoices.paid_date is not null ";


//................................................................
if($start_date)
{
	$sql.="\n and dt_invoices.paid_date>='$start_date' ";
}

if($end_date)
{
	$sql.="\n and dt_invoices.paid_date<='$end_date' ";
}
//.................................................................


//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_invoices.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........


$sql.="\n group by dt_invoices.company_id order by dt_companies.name asc";

//file_put_contents("./pics/sql.txt",$sql); 
//echo nl2br($sql); exit;

return $sql;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function get_reports_invoices($paid_month)
{

//
$start_date=$_POST["start_date"] ? $_POST["start_date"] : date("Y-01-01");
$end_date=$_POST["end_date"];
$companies_id=$this->companies_id ? $this->companies_id : '';
//

$sql="select 

dt_invoices.* 
, dt_invoice_status.name as invoice_status_name
, dt_companies.name as company_name
, dt_currency.name as currency_name

";

//....................................................
if($paid_month)
{
	$sql.="\n ,sum(dt_invoices.paid) as total_paid ";
}
//....................................................


$sql.="

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

left join dt_companies on
dt_invoices.company_id=dt_companies.id

left join dt_currency on
dt_invoices.currency_id=dt_currency.id

where

dt_invoices.id!=''

";


$sql.="\n and dt_invoices.paid_date is not null ";


//................................................................
if($start_date)
{
	$sql.="\n and dt_invoices.paid_date>='$start_date' ";
}

if($end_date)
{
	$sql.="\n and dt_invoices.paid_date<='$end_date' ";
}
//.................................................................


//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_invoices.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........


//status....................................................................
if($invoice_status_id)
{
	$sql.="\n and dt_invoices.invoice_status_id='$invoice_status_id' ";
}
//end status................................................................

//paid_month....................................................................
if($paid_month)
{
	$sql.="\n and month(dt_invoices.paid_date)='$paid_month' group by month(dt_invoices.paid_date) ";
}
//end status................................................................


//file_put_contents("./pics/sql.txt",$sql); 
//echo nl2br($sql); exit;

return $sql;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function index($module_name)
{

//
$companies_id=$this->companies_id ? $this->companies_id : '';
$invoice_status_id=$_GET["invoice_status_id"] ? $_GET["invoice_status_id"] : $_POST["invoice_status_id"];
//

$sql="select 

dt_invoices.* 
, dt_invoice_status.name as invoice_status_name
, dt_companies.name as company_name
, dt_currency.name as currency_name

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

left join dt_companies on
dt_invoices.company_id=dt_companies.id

left join dt_currency on
dt_invoices.currency_id=dt_currency.id

where

dt_invoices.id!=''

";

//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_invoices.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........


//status....................................................................
if($invoice_status_id)
{
	$sql.="\n and dt_invoices.invoice_status_id='$invoice_status_id' ";
}
//end status................................................................

//paid_month....................................................................
if($_GET["paid_month"])
{
	$sql.="\n and month(dt_invoices.paid_date)='$_GET[paid_month]' ";
}
//end status................................................................


//#############################################################################################################
if($_POST["filter_month_year_id"])
{
	switch($_POST["filter_month_year_id"])
	{
		//this month
		case 1:
				$month=date("n",strtotime("this month"));
				$year=date("Y",strtotime("this month"));
				//echo "$month,$year";
				$sql.="\n and month(dt_invoices.issue_date)='$month' and year(dt_invoices.issue_date)='$year' ";
		break;
		//last month
		case 2:
				$month=date("n",strtotime("last month"));
				$year=date("Y",strtotime("last month"));
				//echo "$month,$year";
				$sql.="\n and month(dt_invoices.issue_date)='$month' and year(dt_invoices.issue_date)='$year' ";
		break;
		//last 3 months
		case 3:
				$month=date("n",strtotime("-3 month"));
				$year=date("Y",strtotime("-3 month"));
				//echo "$month,$year";
				$sql.="\n and month(dt_invoices.issue_date)>='$month' and year(dt_invoices.issue_date)>='$year' ";
		break;
		//last 6 months
		case 4:
				$month=date("n",strtotime("-6 month"));
				$year=date("Y",strtotime("-6 month"));
				//echo "$month,$year";
				$sql.="\n and month(dt_invoices.issue_date)>='$month' and year(dt_invoices.issue_date)>='$year' ";
		break;
		//this year
		case 5:
				$year=date("Y",strtotime("this year"));
				//echo "$year";
				$sql.="\n and year(dt_invoices.issue_date)='$year' ";
		break;
		//last year
		case 6:
				$year=date("Y",strtotime("last year"));
				//echo "$year";
				$sql.="\n and year(dt_invoices.issue_date)='$year' ";
		break;
	}
}
//#############################################################################################################


//file_put_contents("./pics/sql.txt",$sql); 
//echo nl2br($sql); exit;

return $sql;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function details($invoice_id)
{
	
$sql="select 

dt_invoices.* 
, dt_invoice_status.name as invoice_status_name
, dt_companies.name as company_name
, dt_currency.name as currency_name
, dt_projects.name AS project_name

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

left join dt_companies on
dt_invoices.company_id=dt_companies.id

left join dt_currency on
dt_invoices.currency_id=dt_currency.id

LEFT JOIN dt_projects ON
dt_invoices.project_id=dt_projects.id

where

dt_invoices.id='$invoice_id'

";

//echo nl2br($sql); 
//exit;

return $this->common->get_query($sql);

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function create_invoice_for_project($project_id)
{

//echo $project_id; exit;

//project details
$record_project=$this->projects_model->details($project_id);

//create invoice..........................................................................................
$id=$this->common->get_new_id("id","dt_invoices");

$sql="insert into 
dt_invoices(id,sum,project_id,reference,company_id) 
values('$id','$_POST[sum]','$project_id','$record_project[reference]','$record_project[company_id]')";

$this->db->query($sql);
//end create invoice..........................................................................................

//set_invoice_id..................
$this->save_invoice_id($id);
//end set_invoice_id..............

//save items of addrows................................................
$this->invoice_has_items_model->save_invoice_has_items($id);
//end save items of addrows................................................

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function save($module_name,$id)
{

//set_invoice_id..................
$this->save_invoice_id($id);
//end set_invoice_id..............

//save items of addrows................................................
$this->invoice_has_items_model->save_invoice_has_items($id);
//end save items of addrows................................................

//send invoice mail to client...............
$this->invoice_sendmail($id);
//end send invoice mail to client...........

//send message to client............................
$this->messages_model->invoice_send_message($id);
//end send message to client........................

//exit;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function invoice_sendmail($id)
{

//invoice details..........................................................
$record=$this->invoices_model->details($id);
//echo "<pre/>"; var_export($record);
$data["record"]=$record;
$message=$this->load->view("invoices/print",$data,true);
//echo $message;
//end invoice details......................................................

//companies clients email list not to be used now, email taken from estimate form.......
//$email_list=$this->clients_model->companies_client_email_list($record["company_id"]);
$email_list=$record["client_email"];
//echo $email_list; exit;
//end companies clients email list......................................................

//get setting values...........................................................................
$site_title=$this->setting_model->get_setting_value("site_title");
//echo "<br/>site_title: ".$site_title;
$admin_email=$this->setting_model->get_setting_value("admin_email");
//echo "<br/>admin_email: ".$admin_email;
$smtp_user=$this->setting_model->get_setting_value("smtp_user");
//echo "<br/>smtp_user: ".$smtp_user;
$smtp_pass=$this->setting_model->get_setting_value("smtp_pass");
//echo "<br/>smtp_pass: ".$smtp_pass; 
//exit;
//end get setting values...........................................................................


//send mail to user...........................................................................
//send mail configuration.....................................................

$config['charset'] = 'utf-8';
$config['wordwrap'] = TRUE;
$config['mailtype'] = 'html';

$this->load->library('email',$config);

//end configuration.................................

//smtp configuration..............................
/*$config['protocol']='smtp';
$config['smtp_host']='ssl://smtp.googlemail.com';
$config['smtp_port']='465';
$config['smtp_user']=$smtp_user;
$config['smtp_pass']=$smtp_pass;
$config['charset']='utf-8';
$config['newline']="\r\n";
$config['mailtype']='html'; // or text or html

$this->load->library('email',$config);
*/
//end smtp configuration..........................


$subject="Invoice From ".$site_title;

/*$message="
Full Name: $_REQUEST[full_name]
<br/>
Phone: $_REQUEST[phone]
<br/>
Subject: $_REQUEST[subject]
<br/>
Message: $_REQUEST[message]
";*/

//echo $_REQUEST["email"]; exit;

$this->email->to($email_list);
$this->email->from($admin_email);
$this->email->subject($subject);
$this->email->message($message);
$this->email->send();

//echo "<pre/>"; var_export($this->email);

$this->session->set_flashdata("msg","Invoice Mail sent successfully!");

//end send mail to user........................................................................


}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function save_invoice_id($id)
{

$invoice_id=str_pad($id,5,'0',STR_PAD_LEFT);

$sql="update 

dt_invoices 

set 

invoice_id='$invoice_id' 

where 

id='$id' 
and 
(invoice_id is null or invoice_id='') 

";

//echo nl2br($sql);
$this->db->query($sql);

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function project_invoice_list($project_id)
{

//
$companies_id=$this->companies_id ? $this->companies_id : '';
	
$sql="select 

dt_invoices.* 
, dt_invoice_status.name as invoice_status_name
, dt_companies.name as company_name
, dt_currency.name as currency_name

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

left join dt_companies on
dt_invoices.company_id=dt_companies.id

left join dt_currency on
dt_invoices.currency_id=dt_currency.id

where

dt_invoices.project_id='$project_id'

";

//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="\n and dt_invoices.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........


//echo nl2br($sql); 
//exit;

return $this->common->get_query_all($sql);

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function company_invoice_list($company_id)
{
	
$sql="select 

dt_invoices.* 
, dt_invoice_status.name as invoice_status_name

from 

dt_invoices 

left join dt_invoice_status on
dt_invoices.invoice_status_id=dt_invoice_status.id

where

dt_invoices.company_id='$company_id'

";


//echo nl2br($sql); exit;

return $this->common->get_query_all($sql);

}
//------------------------------------------------------------------------------------------------------------




}
//class ends