<?php

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Expenses_model extends CI_Model
{


//-----------------------------------------------------------------------------------------------------------------------------
function __construct() 
{
	parent::__construct();
}
//-----------------------------------------------------------------------------------------------------------------------------




//-----------------------------------------------------------------------------------------------------------------------------
function get_expenses_by_year()
{

$sql="select 

year(dt_expenses.date) as year
, ifnull(sum(value),0) as total_expenses 

from 

dt_expenses 

where 

dt_expenses.id!=''

group by year(dt_expenses.date) 

";

$records=$this->common->get_query_all($sql);
//echo "<pre/>"; var_export($records);

return $records;

}
//-----------------------------------------------------------------------------------------------------------------------------




//-----------------------------------------------------------------------------------------------------------------------------
function total_expenses_for_year()
{

//...................................................................
$year=$_POST["search_year"] ? $_POST["search_year"] : date("Y");
//...................................................................

$sql="select 

ifnull(sum(value),0) as total_expenses 
, ifnull(dt_currency.name,'$') as currency_name

from 

dt_expenses 

left join dt_currency on
dt_expenses.currency_id=dt_currency.id

where 

year(dt_expenses.date)='$year' 

";

$record=$this->common->get_query($sql);
//var_export($record);
return array($year,$record["currency_name"],$record["total_expenses"]);


}
//-----------------------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function get_reports_expenses($month)
{

//
$start_date=$_POST["start_date"] ? $_POST["start_date"] : date("Y-01-01");
$end_date=$_POST["end_date"];
$companies_id=$this->companies_id ? $this->companies_id : '';
//

$sql="select 

dt_expenses.*
, dt_expense_status.name as status_name 
, dt_expense_type.name as expense_type_name 
, dt_expense_category.name as expense_category_name 
, dt_projects.company_id

";

//............................................................
if($month)
{
	$sql.="\n ,sum(dt_expenses.value) as total_value ";
}
//.............................................................

$sql.="

from 

dt_expenses 

left join dt_expense_status on
dt_expenses.expense_status_id=dt_expense_status.id

left join dt_expense_type on
dt_expenses.expense_type_id=dt_expense_type.id

left join dt_expense_category on
dt_expenses.expense_category_id=dt_expense_category.id

left join dt_projects on
dt_expenses.project_id=dt_projects.id

where

dt_expenses.id!=''

";


//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_projects.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........


//..........................................................................
if($start_date)
{
	$sql.="\n and dt_expenses.date>='$start_date' ";
}

if($end_date)
{
	$sql.="\n and dt_expenses.date<='$end_date' ";
}
//..........................................................................


//month...................................................................................................
if($month)
{
	$sql.="\n and month(dt_expenses.date)='$month' group by month(dt_expenses.date) ";
}
//end month...............................................................................................


//file_put_contents("./pics/sql.txt",$sql); 
//echo nl2br($sql); exit;

return $sql;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function index($module_name)
{

//...................................................................
$month=$_POST["search_month"] ? $_POST["search_month"] : '';
$year=$_POST["search_year"] ? $_POST["search_year"] : date("Y");
//...................................................................
	
$sql="select 

dt_expenses.*
, dt_expense_status.name as status_name 
, dt_expense_type.name as expense_type_name 
, dt_expense_category.name as expense_category_name 

from 

dt_expenses 

left join dt_expense_status on
dt_expenses.expense_status_id=dt_expense_status.id

left join dt_expense_type on
dt_expenses.expense_type_id=dt_expense_type.id

left join dt_expense_category on
dt_expenses.expense_category_id=dt_expense_category.id

where

dt_expenses.id!=''

";


//agent_id...................................................
if($_POST["agent_id"])
{
	$sql.="\n and agent_id='$_POST[agent_id]' ";
}
//end agent_id...............................................


//month...................................................
if($month)
{
	$sql.="\n and month(dt_expenses.date)='$month' ";
}
//end month...............................................


//year...................................................
if($year)
{
	$sql.="\n and year(dt_expenses.date)='$year' ";
}
//end year...............................................


//...................................................................................................
if($this->session->userdata($module_name."_srch_txt"))
{
	$srch_txt=trim($this->session->userdata($module_name."_srch_txt"));
	$sql.="and 
	(
		dt_expenses.name like '%$srch_txt%' or
		dt_expenses.value like '%$srch_txt%' or
		dt_expenses.description like '%$srch_txt%'
	) 
	";
}
//...................................................................................................

//file_put_contents("./pics/sql.txt",$sql); 
//echo nl2br($sql); exit;

return $sql;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function details($item_id)
{
	
$sql="select 

dt_expenses.* 

from 

dt_expenses 

where

dt_expenses.id='$item_id'

";

//echo nl2br($sql); 
//exit;

return $this->common->get_query($sql);

}
//------------------------------------------------------------------------------------------------------------




}
//class ends