<?php 
$this->load->view("dashboard/header");

//--------------------------------------------------------------------------------------------------------
$module_name="company";

$controller_name="admin";
$module_caption=get_module_caption($module_name);

$order_field="name";
$mandatory_fields="name,company_prefix";//javascript check
$duplicate_fields="name,company_prefix";//database check

$folpath=base_url().'uploadImage/'; //echo $folpath;
$image_width=100;

$data["module_name"]=$module_name;
$data["mandatory_fields"]=$mandatory_fields;

//--------------------------------------------------------------------------------------------------------

?>

<form name="form_<?php echo $module_name?>" id="form_<?php echo $module_name?>" 
action="<?php echo base_url();?>admin/module_form/<?php echo $module_name?>/save/<?php echo $record['id']?>" 
method="post" accept-charset="utf-8" enctype="multipart/form-data">

<div class="card">
		<div class="card-header card-header-icon" data-background-color="rose">
			<i class="material-icons">contacts</i>
		</div>
		<div class="card-content">
			<h4 class="card-title">
			<?php  
			if($record['id']){echo "Edit ";}else{echo "New ";} 
			echo $module_caption;
			?>
			<span class="text_success"><?php echo $this->session->flashdata("msg")?></span>
			</h4>
			
			<div class="form-group label-floating">
				<label class="control-label">Company Name<star>*</star></label>
				<input class="form-control" name="name" type="text" id="name" value="<?php echo $record['name']?>" required />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Prefix<star>*</star></label>
				<input class="form-control" name="company_prefix" type="text"   
				id="company_prefix" value="<?php echo $record['company_prefix']?>" maxlength="4" required  /> 
				(max 4 chars) - to be used in invoice 
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Description</label>
				<input class="form-control" name="description" type="text" id="description" value="<?php echo $record['description']?>" />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Address</label>
				<textarea class="form-control" name="address" rows="4" id="address"><?php echo $record['address']?></textarea>
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Country</label>
					<?php
					//--------------------------------------------------------------------------------------------------
					select_dropdown("country","select country_name,country_name as country_name_alt from dt_country_list",
					$record["country"],"class='form-control' onchange='toggle_states()'","");
					//--------------------------------------------------------------------------------------------------
					?>
					
					<span class="please_wait" id="container_please_wait_country">Please Wait ....</span>
			</div>
			
			<div class="text_label">State / Province</div>
			
			<div class="form-group label-floating">
				<?php /*?><label class="control-label" for="state">State / Province</label><?php */?>
				<span id="container_state">
					<?php  
					//--------------------------------------------------------------------------------------------------
					$data["record"]=$record;
					$this->load->view("ajax/toggle_state",$data);
					//--------------------------------------------------------------------------------------------------
					?>
				</span>
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">City</label>
				<input class="form-control" name="city" type="text" id="city" value="<?php echo $record['city']?>" />
			</div>
			
			<!--zip and latitude longitude-->
			<div class="row">
				
				<div class="col-md-3">
					<div class="form-group label-floating">
						<label class="control-label">Zip</label>
						<input class="form-control" name="zip" type="text" id="zip" value="<?php echo $record['zip']?>" required />
					</div>	
				</div>
				
				<?php /*?><div class="col-md-3">
					<a href="javascript:void()"	onclick="return get_location();">
					<button type="button" class="btn btn-rose btn-xs">Get Location</button>
					</a>
				</div><?php */?>
				
				<div class="col-md-3">
					<div class="form-group label-floating">
						<label class="control-label">Latitude</label>
						<input class="form-control" name="latitude" type="text" id="latitude" 
						value="<?php echo $record['latitude']?>" required />
					</div>	
				</div>
				
				<div class="col-md-3">
					<div class="form-group label-floating">
						<label class="control-label">Longitude</label>
						<input class="form-control" name="longitude" type="text" id="longitude" 
						value="<?php echo $record['longitude']?>" required />
					</div>	
				</div>
				
			</div>
			<!--end zip and latitude longitude-->
			
			
			<div class="form-group label-floating">
				<label class="control-label">Phone</label>
				<input class="form-control" name="phone" type="text" id="phone" value="<?php echo $record['phone']?>" />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Fax</label>
				<input class="form-control" name="fax" type="text" id="fax" value="<?php echo $record['fax']?>" />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Cheques payable to</label>
				<input class="form-control" name="cheques_payable_to" type="text" id="cheques_payable_to" value="<?php echo $record['cheques_payable_to']?>" />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">GST</label>
				<input class="form-control" name="gst" type="text" id="gst" value="<?php echo $record['gst']?>" />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">Website</label>
				<input class="form-control" name="website" type="text" id="website" value="<?php echo $record['website']?>"  />
			</div>
			
			<div class="form-group label-floating">
				<label class="control-label">E-Mail</label>
				<input class="form-control" name="email" type="text" id="email" value="<?php echo $record['email']?>" />
			</div>
			
			<div class="text_label">Logo</div>
			
			<div class="form-group label-floating" <?php if(count($arr_file_list)){echo "style='display: none'";}?>>
				<?php /*?><label class="control-label">Logo</label><?php */?>
				<input class="form-control" type="file" name="file_list" id="file_list" title="Please choose logo" />
			</div>
			
			<div class="form-group label-floating" <?php if(count($arr_file_list)==0){echo "style='display: none'";}?>>
				<?php /*?><label class="control-label">Logo</label><?php */?>
				<?php  
				display_images_with_delete($module_name,"file_list",$record["id"],$arr_file_list,$folpath,$image_width);
				?>
			</div>
			
			<br/>
			
			<div class="form-group label-floating">
				<label class="control-label">Active</label>
				<?php 
				//--------------------------------------------------------------------------------------------------
				$sql="select id,name from dt_active ";
				select_dropdown("active",$sql,$record["active"],"class='form-control' required","");
				//--------------------------------------------------------------------------------------------------
				?>
			</div>
			
			<div class="text-center">
				<button type="submit" class="btn btn-rose btn-fill btn-wd">Submit</button>
				
				<?php
				//only superadmin........................................................
				if($this->user_id==1)
				{
				?>
				<a href="<?php echo base_url()."$controller_name/module_form/$module_name/new/"?>">
				<button type="button" class="btn btn-info btn-fill btn-wd">New</button>
				</a>
				<?php
				}
				//end only superadmin........................................................
				?>
				
			</div>
			
		</div>
		<!--end card content-->
</div>
<!--end card-->

<input type="hidden" name="duplicate_fields" id="duplicate_fields" value="<?php echo $duplicate_fields?>" />

</form>

<script>
jQuery(document).ready(function() 
{
	setFormValidation('#form_company');	
});


//-------------------------------------------------------------------------------------------------------
function get_location()
{

var zip=jQuery("#zip").val();

//
if(!zip)
{
	jQuery("#zip").focus();
}
//

var path=base_url+"ajax/index/get_latlon_for_zip";

jQuery.get(path,{zip:zip},
				function(data)
				{
					var arr=JSON.parse(data);
					//alert(arr["lat"]+" "+arr["lon"]);
					jQuery("#latitude").val(arr["lat"]);
					jQuery("#longitude").val(arr["lon"]);
				});

}
//-------------------------------------------------------------------------------------------------------

</script>

<?php $this->load->view("dashboard/footer");?>