<?php

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Projects_model extends CI_Model
{


//------------------------------------------------------------------------------------------------------------
function __construct() 
{
	parent::__construct();
}
//------------------------------------------------------------------------------------------------------------           




//------------------------------------------------------------------------------------------------------------
//1 - closed, 0 - open
function get_user_project_list($job_completed)
{

//
$companies_id=$this->companies_id ? $this->companies_id : '';

//echo "<br/>job_completed: $job_completed";

$sql="select 

dt_projects.* 
, dt_companies.name as company_name
, dt_projects_category.name as projects_category_name
, (select count(*) from dt_invoices where dt_invoices.project_id=dt_projects.id) as total_invoices

from 

dt_projects 

left join dt_companies on
dt_projects.company_id=dt_companies.id

left join dt_projects_category on
dt_projects.projects_category_id=dt_projects_category.id

where

dt_projects.id!=''

";

//..............................................................
if(isset($job_completed))
{
	$sql.="and dt_projects.job_completed='$job_completed' ";
}
//..............................................................

//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_projects.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........

//echo nl2br($sql); 
//exit;

return $this->common->get_query_all($sql);

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------           
function mark_job_completed()
{

//mark job completed..................................................
if($_POST["job_completed"])
{

//echo "<pre/>"; var_export($_POST);
$id_list=implode(",",$_POST["job_completed"]);

$sql="update dt_projects set job_completed='1' where id in($id_list) ";
//echo nl2br($sql);
$this->db->query($sql);

//exit;

redirect(base_url()."jobs/module_list/projects");

}
//mark job completed..................................................


}
//------------------------------------------------------------------------------------------------------------           




//------------------------------------------------------------------------------------------------------------           
function save_before($module_name,$id)
{

}
//------------------------------------------------------------------------------------------------------------           




//------------------------------------------------------------------------------------------------------------           
function save($module_name,$id)
{

//save reference.................
$this->save_reference($id);
//end save reference.............

//new invoice during new project with service items.................................
if($_POST["create_invoice"])
{
	$this->invoices_model->create_invoice_for_project($id);
}
else if($_POST["update_invoice"])
{

//save items of addrows................................................
$this->invoice_has_items_model->save_invoice_has_items($_POST["invoice_id"]);
//end save items of addrows................................................

//update sum
$sql="update dt_invoices set sum='$_POST[sum]' where id='$_POST[invoice_id]'";
$this->db->query($sql);

}
//end new invoice during new project with service items.................................




//delete old records for reoccuring dates...................................................................
$sql="delete from dt_projects_reoccuring_schedule where project_id='$id' ";
$this->db->query($sql);
//delete old records for reoccuring dates...................................................................

//reoccuring_schedule...................................
if($_POST["set_to_reoccuring"])
{
	$this->reoccuring_schedule($id);
}
//end reoccuring_schedule...............................

}
//------------------------------------------------------------------------------------------------------------           




//------------------------------------------------------------------------------------------------------------
function reoccuring_schedule($project_id)
{

$record_reoccuring_schedule_details=$this->reoccuring_schedule_model->details($_POST["reoccuring_schedule_id"]);
//echo "<pre/>"; var_export($record_reoccuring_schedule_details);
//exit;

//echo "<pre/>"; var_export($_POST); 

$endDate = strtotime($_POST["end"]);
//construct array for dates....................................................................................
for($i = strtotime($record_reoccuring_schedule_details["day_name"], strtotime($_POST["start"])); $i <= $endDate; $i = strtotime('+1 week', $i))
{
	$arr_dates[]=date('Y-m-d', $i);
	//$arr_dates[]=date('l Y-m-d', $i);
}
//end construct array for dates....................................................................................


//e.g. Every 2 Weeks on Fridays - has one week gap, not every weekday..........................
if($record_reoccuring_schedule_details["week_gap"])
{

$arr_odd = array();
$arr_even = array();
$both = array(&$arr_even, &$arr_odd);
array_walk($arr_dates, function($v, $k) use ($both) { $both[$k % 2][] = $v; });

//echo "<pre/>"; var_export($arr_odd);
//echo "<pre/>"; var_export($arr_even);
$arr_dates=$arr_even;

}
//end e.g. Every 2 Weeks on Fridays - has one week gap, not every weekday..........................

//echo "<pre/>"; var_export($arr_dates);
//echo $project_id;

//save reoccuring dates.............................................................
$this->projects_reoccuring_schedule_model->save_dates($project_id,$arr_dates);
//end save reoccuring dates.........................................................

//exit;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function save_reference($id)
{

//set reference.............................................................
$reference="51".str_pad($id,3,0,STR_PAD_LEFT);

$sql="update dt_projects set reference='$reference' where id='$id' ";
$this->db->query($sql);
//end set reference.............................................................

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function index($module_name)
{

//
$companies_id=$this->companies_id ? $this->companies_id : '';

//...............................
$this->mark_job_completed();
//...............................
	
$sql="select 

dt_projects.* 
, dt_companies.name as company_name
, dt_projects_category.name as projects_category_name
, (select count(*) from dt_invoices where dt_invoices.project_id=dt_projects.id) as total_invoices
, (select dt_invoices.id from dt_invoices where dt_invoices.project_id=dt_projects.id order by id desc limit 1) as invoice_id

from 

dt_projects 

left join dt_companies on
dt_projects.company_id=dt_companies.id

left join dt_projects_category on
dt_projects.projects_category_id=dt_projects_category.id

where

dt_projects.id!=''

";

//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_projects.company_id in($companies_id) ";

}
//end users other than superadmin view only their company...........

//job_completed.....................................................
if(isset($_GET["job_completed"]))
{
	$sql.="\n and dt_projects.job_completed='$_GET[job_completed]' ";
}
//end job_completed.................................................


//...................................................................................................
if($this->session->userdata($module_name."_srch_txt"))
{
	$srch_txt=trim($this->session->userdata($module_name."_srch_txt"));
	$sql.="and 
	(
		   dt_projects.reference like '%$srch_txt%'
		or dt_projects.name like '%$srch_txt%'
		or dt_companies.name like '%$srch_txt%'
		or dt_projects_category.name like '%$srch_txt%'
	) 
	";
}
//...................................................................................................


//echo nl2br($sql); 
//file_put_contents("./pics/sql.txt",$sql); 
//exit;

return $sql;

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function companies_project_list($company_id)
{

$sql="select 

*

from

dt_projects

where 

company_id='$company_id'

";

//echo nl2br($sql); exit;

return $this->common->get_query_all($sql);

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function details($project_id)
{
	
$sql="select 

dt_projects.* 
, datediff(dt_projects.end,now()) as days_left 
, datediff(dt_projects.end,dt_projects.start) as days_total 

, dt_companies.name as company_name
, dt_projects_category.name as projects_category_name
, dt_phase.name as phase_name

from 

dt_projects 

left join dt_companies on
dt_projects.company_id=dt_companies.id

left join dt_projects_category on
dt_projects.projects_category_id=dt_projects_category.id

left join dt_phase on
dt_projects.phase_id=dt_phase.id

where

dt_projects.id='$project_id'

";

//users other than superadmin view only their company...............
if($this->user_type_id!=1)
{

$sql.="and dt_projects.company_id in($this->companies_id) ";

}
//end users other than superadmin view only their company...........

//echo nl2br($sql); exit;

//file_put_contents("./pics/sql.txt",$sql); 

return $this->common->get_query($sql);

}
//------------------------------------------------------------------------------------------------------------




}
//class ends